jQuery( function( $ ){

    var $imp = $('#siteorigin-importer'),
        $fr = $imp.find( '.frames .frame' ),
        importerRunning = false;

    $fr.eq(0).show();

    $imp.find( '#import-accept' ).on( 'keyup', function(){
        var $$ = $(this);
        if( $$.val().trim().toLowerCase() == 'accept' ) {
            $imp.find('#start-import').attr('disabled', null);
        }
        else {
            $imp.find('#start-import').attr('disabled', true);
        }
    } );

    $imp.find( '#start-import' ).on( 'click', function(){
        if( ! confirm( importerSettings.strings[ 'confirm-start' ] ) ) {
            return false;
        }

        // To start, show the next frame
        $fr.hide();
        $fr.eq(1).show();
        importerRunning = true;

        // Create a progress bar
        var actions = JSON.parse( JSON.stringify( importerActions ) );

        var i = 0;
        var totalActions = actions.length;
        var thisAction;

        var importAction = function( requestFailed = false ) {

            if ( ! requestFailed ) {
                i++;

                thisAction = actions.shift();

                if( ! importerSettings.strings[ thisAction.action ] ) {
                    importerSettings.strings[ thisAction.action ] = '';
                }

                // Update the progress string
                $fr.find( '.progress-message' ).html(
                    i + '/' + totalActions + ': ' +
                    importerSettings.strings[ thisAction.action ].replace( '%s', thisAction.text )
                );
            }

            // Send this request to the server
            $.get(
                importerSettings.url,
                {
                    'action' : 'importer_action',
                    'importer_action' : thisAction.action,
                    'id' : thisAction.id,
                    'expires' : thisAction.expires,
                    'signature' : thisAction.signature,
                }
            )
            .done( function( r ) {
                $fr.find( '.progress-bar-progress' ).width( ( i / totalActions * 100 ) + '%' );
                if ( thisAction.action == 'reset-installation' ) {
                    // Require the user to log in again.
                    $( document ).trigger( 'heartbeat-tick.wp-auth-check', [ { 'wp-auth-check': false } ] );
                    // Detect log in
                    detectLogin = new MutationObserver( function( mutations, observer ) {
                        if ( ! mutations[0].target.classList.contains( 'modal-open' ) ) {
                            // Log in detected, proceed with import.
                            observer.disconnect();
                            importAction();
                        }
                    } );
                    detectLogin.observe( document.body, { attributes: true } );
                } else if ( ! isImportFinished( thisAction.action ) ) {
                    importAction();
                }
            } )
            .fail( function( r ) {
                // Have we already attempted this action?
                if ( requestFailed ) {
                    // Step failed twice, abort.
                    console.log( 'Importer action failed to import twice. Error code: ' + r.status  );
                } else if ( ! isImportFinished( thisAction.action ) ) {
                    importAction( true );
                }
            } );
        };
        var isImportFinished = function( action ) {
            if( action != 'finalize' ) {
                importerRunning = false;
                return false;
            } else {
                // Display the final frame
                $fr.find('.progress-message').hide();
                $fr.find('.complete-message').show();
                return true;
            }
        }
        importAction();
    } );

    // Confirm before exit if the importer is running
    window.onbeforeunload = confirmExit;
    function confirmExit() {
        if( importerRunning ) {
            return importerSettings.strings.confirm;
        }
    }
} );
